// Copyright 2010 Phidgets Inc.  All rights reserved.
// This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
// view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/

/* This class is the entry point for the LiveCode externals */


#include "lcinterfacekit.h"

/* Mapping LiveCode functions to C++ functions */
EXTERNAL_BEGIN_DECLARATIONS("phidgets_livecode")

// BEGIN USER DECLARATIONS

EXTERNAL_DECLARE_FUNCTION("phidgets_set_OnAttach_Handler", Lcphidget::phidgets_set_OnAttach_Handler)
EXTERNAL_DECLARE_FUNCTION("phidgets_set_OnDetach_Handler", Lcphidget::phidgets_set_OnDetach_Handler)
EXTERNAL_DECLARE_FUNCTION("phidgets_set_OnError_Handler", Lcphidget::phidgets_set_OnError_Handler)
EXTERNAL_DECLARE_FUNCTION("phidgets_open", Lcphidget::phidgets_open)
EXTERNAL_DECLARE_FUNCTION("phidgets_close", Lcphidget::phidgets_close)
EXTERNAL_DECLARE_FUNCTION("phidgets_delete", Lcphidget::phidgets_delete)
EXTERNAL_DECLARE_FUNCTION("phidgets_getdevicename", Lcphidget::phidgets_getDeviceName)
EXTERNAL_DECLARE_FUNCTION("phidgets_getserialnumber", Lcphidget::phidgets_getSerialNumber)
EXTERNAL_DECLARE_FUNCTION("phidgets_getdeviceversion", Lcphidget::phidgets_getDeviceVersion)
EXTERNAL_DECLARE_FUNCTION("phidgets_getdevicestatus", Lcphidget::phidgets_getDeviceStatus)
EXTERNAL_DECLARE_FUNCTION("phidgets_waitforattachment", Lcphidget::phidgets_waitForAttachment)
EXTERNAL_DECLARE_FUNCTION("phidgets_getErrorDescription", Lcphidget::phidgets_getErrorDescription)

EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_set_OnInputChange_Handler", Lcinterfacekit::phidgetsInterfaceKit_set_OnInputChange_Handler)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_set_OnOutputChange_Handler", Lcinterfacekit::phidgetsInterfaceKit_set_OnOutputChange_Handler)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_set_OnSensorChange_Handler", Lcinterfacekit::phidgetsInterfaceKit_set_OnSensorChange_Handler)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_create", Lcinterfacekit::phidgetsInterfaceKit_create)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_getinputcount", Lcinterfacekit::phidgetsInterfaceKit_getInputCount)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_getinputstate", Lcinterfacekit::phidgetsInterfaceKit_getInputState)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_getOutputCount", Lcinterfacekit::phidgetsInterfaceKit_getOutputCount)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_getOutputState", Lcinterfacekit::phidgetsInterfaceKit_getOutputState)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_setOutputState", Lcinterfacekit::phidgetsInterfaceKit_setOutputState)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_getsensorCount", Lcinterfacekit::phidgetsInterfaceKit_getSensorCount)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_getsensorvalue", Lcinterfacekit::phidgetsInterfaceKit_getSensorValue)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_getSensorRawValue", Lcinterfacekit::phidgetsInterfaceKit_getSensorRawValue)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_getsensorchangetrigger", Lcinterfacekit::phidgetsInterfaceKit_getSensorChangeTrigger)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_setsensorchangetrigger", Lcinterfacekit::phidgetsInterfaceKit_setSensorChangeTrigger)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_getRatiometric", Lcinterfacekit::phidgetsInterfaceKit_getRatiometric)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_setRatiometric", Lcinterfacekit::phidgetsInterfaceKit_setRatiometric)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_getDataRate", Lcinterfacekit::phidgetsInterfaceKit_getDataRate)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_setDataRate", Lcinterfacekit::phidgetsInterfaceKit_setDataRate)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_getDataRateMax", Lcinterfacekit::phidgetsInterfaceKit_getDataRateMax)
EXTERNAL_DECLARE_FUNCTION("phidgetsInterfaceKit_getDataRateMin", Lcinterfacekit::phidgetsInterfaceKit_getDataRateMin)
// END USER DECLARATIONS

EXTERNAL_END_DECLARATIONS
